﻿var respondents = {
    context: $(".v-respondents"),
    datatable: null,
    respondentFilter: null,
    nbOfRecords: 0,
    totalRecords: 0,
    initialize: function () {
        $.when(a4.callServerMethod(a4.getSurveyAction("GetRespondentsPageConfiguration", "Analyze"))).then(function (result) {
            respondents.selectedVariables = result;
            respondents.datatable = $(".h-respondents-table", respondents.context).a4datatable({
                lengthMenu: [
                    [10, 20, 50, 100, 500, 1000],
                    ['10', '20', '50', '100', '500', '1000']
                ],
                advancedFilter: true,
                height: "full",
                ajaxAction: a4.getSurveyAction("GetRespondents", "Analyze"),
                ajaxParams: { "variables": result },
                columns: [
                    { "Name": "Id", "Title": resources.Id, "Data": "Id", "HideInSelector": true, "Key": true, "Type": "numeric" },
                    { "Name": "Pin", "Title": resources.Pin, "Data": "Pin" },
                    { "Name": "Email", "Title": resources.Email, "Data": "Email", "Visible": canReadPII, "HideInSelector": !canReadPII },
                    { "Name": "EmailStatus", "Title": resources.EmailStatus, "Data": "EmailStatus", "Type": "enum", "EnumType": "EmailInvitationStatus" },
                    { "Name": "Phone", "Title": resources.Phone, "Data": "Phone", "Visible": false, "HideInSelector": !canReadPII },
                    { "Name": "PhoneStatus", "Title": resources.PhoneStatus, "Data": "PhoneStatus", "Type": "enum", "EnumType": "SMSMessageStatus", "Visible": false },
                    { "Name": "Disposition", "Title": resources.Result, "Data": "Disposition", "Type": "enum", "EnumType": "DispositionCode" },
                    { "Name": "Location", "Title": resources.Location, "Data": "Location", "Type": "enum", "EnumType": "RespondentLocation", "Visible": isOfflineSurvey, "HideInSelector": !isOfflineSurvey },
                    { "Name": "OfflineUserName", "Title": resources.OfflineUser, "Data": "OfflineUserName", "Visible": isOfflineSurvey, "HideInSelector": !isOfflineSurvey },
                    { "Name": "AppointmentDate", "Title": resources.Appointment, "Data": "AppointmentDate", "Visible": isOfflineSurvey, "HideInSelector": !isOfflineSurvey },
                    { "Name": "AccessExpirationDate", "Title": resources.AccessExpiration, "Data": "AccessExpirationDate", "Visible": false },
                    { "Name": "Active", "Title": resources.Active, "Data": "Active", "Label": "ActiveLabel", "Type": "boolean", "ShowIcon": true },
                    { "Name": "Simulated", "Title": resources.Simulated, "Data": "Simulated", "Label": "SimulatedLabel", "Type": "boolean", "ShowIcon": true },
                    { "Name": "IsAnonymized", "Title": resources.Anonymized, "Data": "IsAnonymized", "Label": "IsAnonymizedLabel", "Type": "boolean", "ShowIcon": true },
                    { "Name": "LastActivity", "Title": resources.LastActivity, "Data": "LastActivity", "Type": "datetime" },
                    { "Name": "ModifiedOn", "Title": resources.ModifiedOn, "Data": "ModifiedOn", "Visible": false, "Type": "datetime" },
                    { "Name": "Variable0", "Title": "Variable0", "Data": "Variable0", "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": "Variable1", "Title": "Variable1", "Data": "Variable1", "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": "Variable2", "Title": "Variable2", "Data": "Variable2", "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": "Variable3", "Title": "Variable3", "Data": "Variable3", "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": "Variable4", "Title": "Variable4", "Data": "Variable4", "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": "Variable5", "Title": "Variable5", "Data": "Variable5", "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": "Variable6", "Title": "Variable6", "Data": "Variable6", "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": "Variable7", "Title": "Variable7", "Data": "Variable7", "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": "Variable8", "Title": "Variable8", "Data": "Variable8", "Visible": false, "HideInSelector": true, "EncodeHtml": true },
                    { "Name": "Variable9", "Title": "Variable9", "Data": "Variable9", "Visible": false, "HideInSelector": true, "EncodeHtml": true }],
                localizableTexts: { "Search": resources.SearchRespondents },
                stateKey: "Respondents",
                stateSaveSorting: false,
                toolBarItems: respondents.getToolBarItems(),
                //allowRowSelection: "!isOfflineSurvey || [LocationValue]!=1",
                toolBarClick: function (event, data) {
                    var rows = data.rows;
                    var action = data.action;
                    var respondentIds = _.map(rows, function (row) { return row.Id });

                    switch (action) {
                        case "export":
                            var tableParams = respondents.datatable.a4datatable("getTableParams");
                            var link = a4.getSurveyAction("ExportRespondents", "Analyze");
                            var params = { tableParams: JSON.stringify(tableParams), filter: JSON.stringify(respondents.respondentFilter), variables: respondents.selectedVariables };
                            respondents.exportFile(link, params, "GetRespondentsFile")
                            break;
                        case "variables":
                            modalDialog.showWindow(a4.getSurveyAction("VariableSelector", "Shared", { variables: respondents.selectedVariables || "" }), 600, 800, {
                                beforeClose: function () {
                                    var variableSelector = $('.fancybox-iframe').contents();
                                    var confirmed = variableSelector.find(".v-confirmed").val();
                                    if (confirmed) {
                                        var value = variableSelector.find('.v-selectedVariables').val();
                                        respondents.selectVariables(value);
                                    }
                                }
                            });
                            break;
                        case "activateFiltered":
                            respondents.changeActivityFilteredRespondents(true);
                            break;
                        case "deactivateFiltered":
                            respondents.changeActivityFilteredRespondents(false);
                            break;
                        case "deleteFiltered":
                            respondents.deleteFilteredRespondents();
                            break;
                        case "activate":
                            respondents.updateRespondentsStatus(respondentIds, true);
                            break;
                        case "deactivate":
                            respondents.updateRespondentsStatus(respondentIds, false);
                            break;
                        case "reset":
                            respondents.resetRespondents(respondentIds);
                            break;
                        case "delete":
                            respondents.deleteRespondents(respondentIds);
                            break;
                        case "modifyDisposition":
                            modalDialog.showWindow(a4.getSurveyAction("RespondentModifyDispositions", "Analyze", { respondentCount: respondentIds.length }), 250, 500);
                            break;
                        case "assignUserRespondents":
                            respondents.assignUserRespondents();
                            break;
                        case "resetLocation":
                        case "resetFilteredLocation":
                            respondents.resetLocation(respondentIds);
                            break;
                        case "setAccessExpirationDate":
                            modalDialog.showWindow(a4.getSurveyAction("ModifySelectedRespondentAccessExpirations", "Analyze", { respondentCount: respondentIds.length }), 570, 500);
                            break;
                        case "setAccessExpirationDateFiltered":
                            respondents.changeFilteredRespondentAccessExpirations();
                            break;
                        case "anonymizeSelected":
                            respondents.anonymizeSelected();
                            break;
                        case "anonymizeFiltered":
                            respondents.anonymizeFiltered();
                            break;
                    };
                },
                contextMenuItems: respondents.getContextMenuItems(),
                contextMenuClick: function (event, data) {
                    var row = data.row;
                    var action = data.action;

                    switch (action) {
                        case "properties":
                            modalDialog.showWindow(a4.getSurveyAction("RespondentProperties", "Analyze", { respondentId: row.Id }), 600, 800, { afterClose: function () { respondents.refreshContent(); } });
                            break;
                        case "responses":
                            modalDialog.showWindow(a4.getSurveyAction("Responses", "Analyze", { respondentId: row.Id }), 680, 1000, {
                                afterClose: function () {
                                    respondents.refreshContent();
                                }
                            });
                            break;
                        case "anonymizeSingle":
                            respondents.anonymizeSingle(row.Id);
                            break;
                        case "modifLogs":
                            modalDialog.showWindow(a4.getSurveyAction("ResponsesLogs", "Analyze", { respondentId: row.Id }), 680);
                            break;
                        case "files":
                            modalDialog.showWindow(a4.getSurveyAction("RespondentFiles", "Analyze", { id: row.Id }), 620);
                            break;
                        case "viewResponses":
                            a4.viewSurveyResponses(surveyMenu.survey.UseS2, row.SurveyToken);
                            break;
                        case "exportResponses":
                            a4.viewSurveyResponses(surveyMenu.survey.UseS2, row.SurveyToken, true);
                            break;
                        case "history":
                            modalDialog.showWindow(a4.getSurveyAction("RespondentActivityHistory", "Analyze", { id: row.Id }), 600);
                            break;
                        case "quotas":
                            modalDialog.showWindow(a4.getSurveyAction("RespondentQuotaStatus", "Analyze", { id: row.Id }), 620);
                            break;
                        case "reset":
                            respondents.resetRespondents([row.Id]);
                            break;
                        case "delete":
                            respondents.deleteRespondents([row.Id]);
                            break;
                        case "resetLocation":
                            respondents.resetLocation([row.Id]);
                            break;                      
                    }
                },
                draw: function () {
                    respondents.nbOfRecords = parseInt($(this).a4datatable("getDisplayedRecords"), 10);
                    respondents.totalRecords = parseInt($(this).a4datatable("getTotalRecords"), 10);
                },
                ready: function () {
                    respondents.toggleVariableColumns();
                }
            });
        });
    },
    getToolBarItems: function () {
        //var nbSelected = respondents.datatable.a4datatable("getSelectedItems"); 

        var locationServerCondition = function (data) { return !data.isOfflineSurvey || data.LocationValue != 1; };

        var items = [
            { "Action": "variables", "Label": resources.SelectVariables, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
            { "Action": "export", "Label": resources.ExportResponses, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "Visible": canExportResponses },
            { "Action": "activateFiltered", "Label": resources.ActivateCases, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "Visible": canChangeRespondentStatus, "DisplayCondition": locationServerCondition },
            { "Action": "deactivateFiltered", "Label": resources.DeactivateCases, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "Visible": canChangeRespondentStatus, "DisplayCondition": locationServerCondition },
            { "Action": "deleteFiltered", "Label": resources.DeleteRespondents, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "Visible": canDelete, "DisplayCondition": locationServerCondition },
            { "Action": "anonymizeFiltered", "Label": resources.AnonymizeCases, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "Visible": canModify && canReadPII, "DisplayCondition": locationServerCondition },
            { "Action": "activate", "Label": resources.ActivateCases, "Visible": canChangeRespondentStatus, "DisplayCondition": locationServerCondition },
            { "Action": "deactivate", "Label": resources.DeactivateCases, "Visible": canChangeRespondentStatus, "DisplayCondition": locationServerCondition },
            { "Action": "anonymizeSelected", "Label": resources.AnonymizeSelectedCases, "Visible": canModify && canReadPII, "DisplayCondition": locationServerCondition },
            { "Action": "reset", "Label": resources.ResetCases, "Visible": canModify, "DisplayCondition": locationServerCondition },
            { "Action": "delete", "Label": resources.DeleteCases, "Visible": canDelete, "DisplayCondition": locationServerCondition },
            { "Action": "setAccessExpirationDate", "Label": resources.SetAccessExpirationDate, "Visible": canModify, "DisplayCondition": locationServerCondition },
            { "Action": "setAccessExpirationDateFiltered", "Label": resources.SetAccessExpirationDate, "Visible": canModify, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "DisplayCondition": locationServerCondition },
            { "Action": "modifyDisposition", "Label": resources.ModifyDisposition, "Visible": canModify, "DisplayCondition": locationServerCondition },
            { "Action": "assignUserRespondents", "Label": resources.AssignUser, "DisplayMode": dataTables.itemDisplayMode.nonSelected, "Visible": isOfflineSurvey && canModify }
        ];

        if (isOfflineSurvey) {
            items.push({ "Action": "resetLocation", "Label": resources.ResetLocation, "Visible": canModify });
            items.push({ "Action": "resetFilteredLocation", "Label": resources.ResetLocation, "Visible": canModify, "DisplayMode": dataTables.itemDisplayMode.nonSelected });
        }

        return items;
    },
    getContextMenuItems: function () {
        var isPublished = surveyMenu.survey.IsPublished;
        var locationServerCondition = function (data) { return !data.isOfflineSurvey || data.LocationValue != 1; };
        var items = [
            { "Action": "history", "Label": resources.ViewActivityHistory },
            { "Action": "quotas", "Label": resources.ViewQuotaStatus },
            { "Divider": true },
            { "Action": "responses", "Label": resources.EditResponses, "Visible": canModify },
            { "Action": "viewResponses", "Label": resources.ViewResponses, "Visible": canReadPII && isPublished },
            { "Action": "exportResponses", "Label": resources.DownloadResponses, "Visible": canReadPII && isPublished },
            { "Divider": true },
            { "Action": "modifLogs", "Label": resources.ViewModifLogs, "Visible": !isSaaS },
            { "Action": "files", "Label": resources.ViewFiles, "Visible": hasFiles },
            { "Divider": true },
            { "Action": "anonymizeSingle", "Label": resources.AnonymizeCase, "Visible": canModify && canReadPII, "DisplayCondition": locationServerCondition },
            { "Action": "delete", "Label": resources.DeleteCase, "Visible": canDelete, "DisplayCondition": locationServerCondition },
            { "Action": "reset", "Label": resources.ResetCase, "Visible": canModify, "DisplayCondition": locationServerCondition },
            { "Action": "properties", "Label": resources.Properties, "Visible": canModify },            
        ];

        if (isOfflineSurvey) {
            items.push({ "Divider": true, "DisplayCondition": function (data) { return data.LocationValue == 1; } });
            items.push({ "Action": "resetLocation", "Label": resources.ResetLocation, "Visible": canModify, "DisplayCondition": function (data) { data.LocationValue == 1; } });
        }

        return items;
    },
    bindEvents: function () {
        this.context.on("click", ".h-findAndReplace", function () {
            $("#DataTableParams").val(JSON.stringify(respondents.datatable.a4datatable('getTableParams')));
            $("#SelectedVariables").val(respondents.selectedVariables);

            modalDialog.showWindow(a4.getSurveyAction("FindAndReplace", "Analyze"), 600, null, {
                afterClose: function () {
                    respondents.refreshContent();
                }
            });
        });

        this.context.on("click", ".h-viewFiles", function () {
            modalDialog.showWindow(a4.getSurveyAction("RespondentFiles", "Analyze"), 620, null);
        });

        this.context.on("click", ".h-deleteAllCases", function () {
            respondents.deleteAllRespondents(null);
        });

        this.context.on("click", ".h-synchronizePanelData", function () {
            respondents.synchronizePanelData(null);
        });

        this.context.on("click", ".h-synchronizePanelHistory", function () {
            respondents.displayPanelSyncrhonizationHistory();
        });

        this.context.on("click", ".section-header, .v-createFilterMessage", function () {
            var sectionBox = $(this).closest(".section-box");
            respondents.toggleRespondentFilter(sectionBox);
        });

        this.context.on("click", ".h-applyFilter", function () {
            respondentFilter.getFilter(function (filter) {
                $(".v-respondentFilterSummary", respondents.context).html(filter.Summary);
                $("#FilterDefinition").val(JSON.stringify(filter.Definition));

                if (filter.IsValid) {
                    respondents.respondentFilter = filter.Definition;
                    respondents.datatable.a4datatable("option", "ajaxParams", { "filter": JSON.stringify(filter.Definition) });
                    respondents.datatable.a4datatable("refresh", true);
                }
            });
        });

        this.context.on("click", ".h-clearFilter", function () {
            respondentFilter.clearFilter();

            if (respondents.respondentFilter) {
                respondents.respondentFilter = null;
                $(".v-respondentFilterSummary", respondents.context).text("");
                respondents.datatable.a4datatable("option", "ajaxParams", { "filter": null });
                respondents.datatable.a4datatable("refresh", true);

                var sectionBox = $(this).closest(".section-box");

                if (!$(".section-content", sectionBox).is(":visible")) {
                    $(".v-createFilterMessage", sectionBox).show();
                    $(".buttons", sectionBox).hide();
                }
            }
        });

        this.context.on("click", ".h-exportSummary", function () {
            var columns = respondents.datatable.a4datatable("getVisibleColumns");
            var tableParams = respondents.datatable.a4datatable("getTableParams");

            var link = a4.getSurveyAction("ExportRespondentsSummary", "Analyze");
            var params = { tableParams: JSON.stringify(tableParams), filter: JSON.stringify(respondents.respondentFilter), columns: columns.join(), variables: respondents.selectedVariables };

            respondents.exportFile(link, params, "GetRespondentsSummaryFile");
        });

        surveyMenu.onBeforeRefresh = function () {
            document.location.reload();
        };
    },
    resetRespondents: function (respondentIds) {
        modalDialog.showConfirmDialog(confirmResetCasesResources, function () {
            a4.callServerMethod(a4.getSurveyAction("ResetRespondents", "Analyze"), { respondentIds: respondentIds },
                function (result) {
                    respondents.refreshContent();
                });
        }, 250, 500, true, { "count": respondentIds.length });
    },
    deleteRespondents: function (respondentIds) {
        modalDialog.showConfirmDialog(confirmDeleteCasesResources, function () {
            a4.callServerMethod(a4.getSurveyAction("DeleteRespondents", "Analyze"), { respondentIds: respondentIds },
                function (result) {
                    respondents.refreshContent();
                });
        }, 250, 500, true, { "count": respondentIds.length });
    },
    changeActivityFilteredRespondents: function (active) {
        var count = respondents.totalRecords;

        var tableParams = respondents.datatable.a4datatable("getTableParams");

        modalDialog.showConfirmDialog(active ? confirmActiveStatusResources : confirmInactiveStatusResources, function () {
            a4.callServerMethod(a4.getSurveyAction("SetRespondentActivity", "Analyze"), { tableParams: JSON.stringify(tableParams), filter: JSON.stringify(respondents.respondentFilter), active: active },
                function (result) {
                    respondents.refreshContent();
                });
        }, 250, 500, true, { "count": count });
    },
    deleteFilteredRespondents: function () {
        var tableParams = respondents.datatable.a4datatable("getTableParams");
        var count = (isOfflineSurvey) ? respondents.getCountByLocation() : respondents.nbOfRecords;

        var link = a4.getSurveyAction("DeleteFilteredRespondents", "Analyze");
        var params = { tableParams: JSON.stringify(tableParams), filter: JSON.stringify(respondents.respondentFilter), hasFiles: hasFiles };

        if (respondents.nbOfRecords == respondents.totalRecords && !respondents.respondentFilter) {
            link = a4.getSurveyAction("DeleteAllRespondents", "Analyze");
            params = {};
        }

        modalDialog.showConfirmDialog(confirmDeleteFilteredCasesResources, function () {
            a4.callServerMethod(link, params,
                function (result) {
                    respondents.refreshContent();
                });
        }, 250, 500, true, { "count": count });
    },
    changeFilteredRespondentAccessExpirations: function () {
        var link = a4.getSurveyAction("RespondentModifyAccessExpirations", "Analyze", {
            respondentCount: respondents.nbOfRecords
        });
        modalDialog.showWindow(link, 600, 500, {
            afterClose: function () {
                respondents.refreshContent();
            }
        });
    },
    assignUserRespondents: function () {
        var link = a4.getSurveyAction("AssignUserRespondents", "Analyze", {
            respondentCount: respondents.nbOfRecords
        });
        modalDialog.showWindow(link, 300, 500);
    },
    modifyDispositions: function (disposition) {
        var rows = respondents.datatable.a4datatable("getSelectedItems");
        var respondentIds = _.map(rows, function (row) { return row.Id });

        a4.callServerMethod(a4.getSurveyAction("UpdateRespondentsDispositions", "Analyze"), { respondentIds: respondentIds, disposition: disposition },
            function (result) {
                respondents.refreshContent();
            });

        return modalDialog.close();
    },
    modifyAccessExpirations: function (accessExpirationDate) {
        var rows = respondents.datatable.a4datatable("getSelectedItems");
        var respondentIds = _.map(rows, function (row) { return row.Id });

        a4.callServerMethod(a4.getSurveyAction("UpdateRespondentsAccessExpirations", "Analyze"), { respondentIds: respondentIds, accessExpirationDate: accessExpirationDate },
            function (result) {
                if (result.success) {
                    respondents.refreshContent();
                    modalDialog.close();
                }
                else
                    a4.showErrorMessage(result.error);
            });
    },
    getCountByLocation: function (locationVal) {
        if (locationVal === undefined) {
            locationVal = 0;
        }

        var count = 0;
        var tableParams = respondents.datatable.a4datatable("getTableParams");
        a4.callServerMethod(a4.getSurveyAction("GetRespondentCountByLocation", "Analyze"), { location: locationVal, tableParams: JSON.stringify(tableParams), filter: JSON.stringify(respondents.respondentFilter) },
            function (result) {
                count = result.count;
            }, function () { }, { "async": false });

        return count;
    },
    resetLocation: function (respondentIds) {
        var count = respondentIds.length > 0 ? respondentIds.length : respondents.getCountByLocation(1);

        var tableParams = respondents.datatable.a4datatable("getTableParams");
        modalDialog.showConfirmDialog(confirmResetLocationResources, function () {
            a4.callServerMethod(a4.getSurveyAction("ResetRespondentLocation", "Analyze"), { respondentIds: respondentIds, tableParams: JSON.stringify(tableParams), filter: JSON.stringify(respondents.respondentFilter) },
                function (result) {
                    respondents.refreshContent();
                });
        }, 250, 500, true, { "count": count });
    },
    deleteAllRespondents: function () {
        modalDialog.showConfirmDialog(confirmDeleteAllCasesResources, function () {
            a4.callServerMethod(a4.getSurveyAction("DeleteAllRespondents", "Analyze"), {},
                function (result) {
                    respondents.refreshContent();
                });
        }, 250, 500, true, {});
    },
    synchronizePanelData: function () {
        modalDialog.showWindow(a4.getSurveyAction("SynchronizePanelData", "Analyze"), 300, 440);
    },
    displayPanelSyncrhonizationHistory: function () {
        modalDialog.showWindow(a4.getSurveyAction("ViewSynchronizePanelDataHistory", "Analyze"), 600, 800);
    },
    updateRespondentsStatus: function (respondentIds, active) {

        var count = respondentIds.length;

        modalDialog.showConfirmDialog(active ? confirmActiveStatusResources : confirmInactiveStatusResources, function () {
            a4.callServerMethod(a4.getSurveyAction("UpdateRespondentsStatus", "Analyze"), { respondentIds: respondentIds, active: active },
                function (result) {
                    respondents.refreshContent();
                });
        }, 250, 500, true, { "count": count });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    selectedVariables: null,
    selectVariables: function (variables) {
        respondents.selectedVariables = variables;

        respondents.toggleVariableColumns();

        respondents.datatable.a4datatable("option", "ajaxParams", { "variables": variables });
        respondents.datatable.a4datatable("option", "defaultSorting", [[1, "ASC"]]);
        respondents.datatable.a4datatable("refresh", true);

        a4.callServerMethod(a4.getSurveyAction("UpdateRespondentsPageConfiguration", "Analyze"), { config: variables }, function (result) { });
    },
    toggleVariableColumns: function () {
        var varArray = [];

        if (respondents.selectedVariables) {
            varArray = respondents.selectedVariables.split(",");
        }

        for (var index = 0; index < 10; index++) {
            var columnName = "Variable" + index;
            var showColumn = varArray[index] != undefined;
            respondents.datatable.a4datatable("toggleColumn", columnName, showColumn);
            respondents.datatable.a4datatable("changeColumnTitle", columnName, varArray[index]);
        }
    },
    toggleRespondentFilter: function (sectionBox) {
        sectionBox.find(".section-header .fa").toggleClass("fa-caret-down fa-caret-right");
        $(".section-content", sectionBox).toggle();

        if ($(".section-content", sectionBox).is(":visible") || respondents.respondentFilter) {
            $(".v-createFilterMessage", sectionBox).hide();
            $(".buttons", sectionBox).show();
        }
        else {
            $(".v-createFilterMessage", sectionBox).show();
            $(".buttons", sectionBox).hide();
        }

        //To trigger datatable adjust height
        $(window).trigger("resize");
    },
    exportFile: function (exportMethod, exportParams, getFileMethod) {
        a4.showBusyBox();

        a4.callServerMethod(exportMethod, exportParams,
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getSurveyAction(getFileMethod, "Analyze", { fileName: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
    },
    anonymizeFiltered: function () {
        var tableParams = respondents.datatable.a4datatable("getTableParams");
        var count = (isOfflineSurvey) ? respondents.getCountByLocation() : respondents.nbOfRecords;

        var link = a4.getSurveyAction("AnonymizeFilteredRespondents", "Analyze");
        var params = { tableParams: JSON.stringify(tableParams), filter: JSON.stringify(respondents.respondentFilter), variables: respondents.selectedVariables };

        modalDialog.showConfirmDialog(confirmAnonymizeResources, function () {
            a4.callServerMethod(link, params,
                function (result) {
                    respondents.refreshContent();
                });
        }, 300, 550, true, { "count": count });
    },
    anonymizeSingle: function (rowId) {
        modalDialog.showConfirmDialog(confirmAnonymizeResources, function () {
            a4.callServerMethod(a4.getSurveyAction("AnonymizeSelectedRespondents", "Analyze"), { respondentIds: [rowId] },
                function (result) {
                    respondents.refreshContent();
                });
        }, 300, 550, true, { "count": 1 });
    },
    anonymizeSelected: function () {
        var rows = respondents.datatable.a4datatable("getSelectedItems");
        var respondentIds = _.map(rows, function (row) { return row.Id });
        modalDialog.showConfirmDialog(confirmAnonymizeResources, function () {
            a4.callServerMethod(a4.getSurveyAction("AnonymizeSelectedRespondents", "Analyze"), { respondentIds: respondentIds },
                function (result) {
                    respondents.refreshContent();
                });
        }, 300, 550, true, { "count": rows.length });
    }
};

var respondentProperties = {
    context: $(".v-respondentProperties"),
    initialize: function () {
        $(".h-datepicker", respondentProperties.context).datetimepicker({
            minDate: new Date(),
            showAnim: "",
            beforeShow: function (input, inst) {
                $(".v-respondentProperties .content").scrollTop(0);
            }
        });

        $(".v-respondentProperties .content").on("scroll", function () {
            if ($(".h-datepicker").datepicker("widget").is(":visible") && $(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight) {
                $(".h-datepicker").datetimepicker('hide');
                $(".h-datepicker").blur();
            }
        });
    }
};

var respondentModifyAccessExpirationDialog = {
    context: $(".v-modifyAccessExpiration"),
    initialize: function () {
        var minDate = new Date();
        $(".h-datepicker").datetimepicker({
            minDate: minDate,
            onSelect: function (selected) {
                $("#AccessExpirationDate").val(selected);
            }
        });
        $("#AccessExpirationDate").change(function () {
            $(".h-datepicker").datetimepicker("setDate", $("#AccessExpirationDate").val());
        });

        $("#TableParams").val(JSON.stringify(parent.respondents.datatable.a4datatable("getTableParams")));
        $("#RespondentFilter").val(JSON.stringify(parent.respondents.respondentFilter));
    }
};

$(document).ready(function () {
    if (respondents.context.length > 0) {
        respondents.initialize();
        respondents.bindEvents();
    }

    if (respondentProperties.context.length > 0) {
        respondentProperties.initialize();
    }

    if (respondentModifyAccessExpirationDialog.context.length > 0) {
        respondentModifyAccessExpirationDialog.initialize();
    }
});